(function () {

    function getBookingLinkToken(url) {
        return url ? url.replace(/#.*$/, '').replace(/\?.*$/, '').replace(/^(.*?)([^/]+)$/, '$2') : '';
    }

    function receiveMessage(event) {
        if (typeof event.data !== 'string') {
            return;
        }
        try {
            let data = JSON.parse(event.data),
                from = data.from || '',
                subj = data.subj || '',
                src = data.src || '';
            if (!src || from != 'booking_link')
                return;
            let iframes = document.getElementsByTagName('iframe'), i;
            if (subj == 'embed_stat') {
                // send data back to the iframe
                for (i = 0; i < iframes.length; i++) {
                    if (getBookingLinkToken(iframes[i].getAttribute('src')) == getBookingLinkToken(src)) {
                        iframes[i].contentWindow.postMessage(JSON.stringify({
                            subj: 'embed_stat',
                            href: document.location.href
                        }), event.origin);
                    }
                }
                return;
            }
            let height = data.scrollHeight || 0;
            if (!height)
                return;
            // search target frame
            for (i = 0; i < iframes.length; i++) {
                if (getBookingLinkToken(iframes[i].getAttribute('src')) == getBookingLinkToken(src) && !iframes[i].getAttribute('data-fixed-height')) {
                    // resize
                    iframes[i].height = height;
                }
            }
        } catch (err) {
            //
        }
    }

    // receive message with height info from iframe
    if ('addEventListener' in window) {
        window.addEventListener('message', receiveMessage, false);
    } else if ('attachEvent' in window) {
        // IE
        window.attachEvent('onmessage', receiveMessage);
    }

    let iId, ic = 0, inv = 50;

    function passUrlParams() {
        ic += inv;
        let iframes = document.getElementsByTagName('iframe');
        let i, iframe, found = false;
        // get params from the current url
        let params = document.location.search.replace(/^\?/, '').split('&');
        // search target frame
        for (i = 0; i < iframes.length; i++) {
            iframe = iframes[i];
            let s = iframe.getAttribute('src'),
                s2 = s,
                t = getBookingLinkToken(iframe.getAttribute('src'));
            // found valid token, should be the desired elm
            if (/^[a-zA-Z0-9]+$/.test(t) && iframe.getAttribute('data-embed-helper') !== '1') {
                found = true;
                // get iframe url params
                let p2 = s.replace(/#.*$/, '').replace(/^.*?\?/, '').split('&');
                // ...and get the names only
                for (let j = 0; j < p2.length; j++) {
                    p2[j] = p2[j].split('=')[0];
                }
                // add param from the current url to the iframe url
                for (let j = 0; j < params.length; j++) {
                    let sp = params[j].split('=');
                    // skip params with quotes for now
                    if (/(\'|\%27)/.test(sp[1]))
                        continue;
                    // don't overwrite existing iframe params
                    if (p2.includes(sp[0]))
                        continue;
                    s2 += (/\?/.test(s2) ? '&' : '?') + params[j];
                }
                // update src if changed
                if (s2 !== s) {
                    iframe.setAttribute('src', s2);
                }
                iframe.setAttribute('data-embed-helper', '1');
            }
        }
        // support dynamic content
        if (ic < 2000) {
            return;
        }
        if (!found || ic > 5000) {
            clearInterval(iId);
        }
    }

    document.addEventListener('DOMContentLoaded', (event) => {
        iId = setInterval(passUrlParams, inv);
    });

})();
